definition module ospicture


//	Version 1.0

//
//	Drawing functions and other operations on Pictures. 
//

from	StdFunc		import St
from	intrface	import HDC
from	ostoolbox	import OSToolbox
from	osrgn		import OSRgnHandle
import	StdFont, StdPictureDef


::	Picture
::	Origin
	:==	Point
::	OSPictContext
	:==	HDC
::  Pen
	=	{	penSize			:: !Int				// The width and height of the pen
  		,	penForeColour	:: !Colour			// The drawing colour of the pen
		,	penBackColour	:: !Colour			// The background colour of the pen
		,	penPos			:: !Point			// The pen position in local coordinates
		,	penFont			:: !Font			// The font information to draw text and characters
		}

/*	Conversion operations to and from Picture.
	To open/close a picture context:
		packPicture   creates a Picture, given the proper OS resources. The picture is initialised.
		unpackPicture unpacks a Picture, releasing the proper OS resources.
	To open/close an existing picture:
		peekPicture   gives you the components of a Picture
		unpeekPicture restores the components to a Picture
	To obtain a read-only picture:
		sharePicture  creates a copy of the Picture. This copy does not occupy OS resources.
*/
packPicture				:: !Origin !Pen !OSPictContext !*OSToolbox -> *Picture
unpackPicture			:: !*Picture -> (!Origin,!Pen,!OSPictContext,!*OSToolbox)
peekPicture				:: !*Picture -> (!Origin,!Pen,!OSPictContext,!*OSToolbox)
unpeekPicture			:: !Origin !Pen !OSPictContext !*OSToolbox -> *Picture
peekOSPictContext		:: !*Picture -> (!OSPictContext,!*Picture)
sharePicture			:: !*Picture -> (!Picture,!*Picture)

defaultPen				:: Pen		// The Pen for customised drawing operations
dialogPen				:: Pen		// The Pen for system     drawing operations


//	Picture interface functions.
apppicttoolbox			:: !(IdFun *OSToolbox)		!*Picture -> *Picture
accpicttoolbox			:: !(St *OSToolbox .x)		!*Picture -> (!.x,!*Picture)


/*	Attribute functions.
*/
getpictattributes		::							! Picture -> [PictureAttribute]
setpictattributes		:: ![PictureAttribute]		!*Picture -> *Picture

//	Access to Origin and Pen:
getpictorigin			::							!*Picture -> (!Origin,!*Picture)
getpictpen				::							!*Picture -> (!Pen,   !*Picture)

//	PenPos attributes:
setpictpenpos			:: !Point					!*Picture -> *Picture
accpictpenpos			::							!*Picture -> (!Point,!*Picture)
getpictpenpos			::							! Picture -> Point
movepictpenpos			:: !Vector					!*Picture -> *Picture
// Move the pen position over the given vector

//	PenSize attributes:
setpictpensize			:: !Int						!*Picture -> *Picture 	
accpictpensize			::							!*Picture -> (!Int,!*Picture)
getpictpensize			::							! Picture -> Int

//	PenColour attributes:
setpictpencolour		:: !Colour					!*Picture -> *Picture
accpictpencolour		::							!*Picture -> (!Colour,!*Picture)
getpictpencolour		::							! Picture -> Colour

//	PenFont attributes:
setpictpenfont			:: !Font					!*Picture -> *Picture
accpictpenfont			::							!*Picture -> (!Font,!*Picture)
getpictpenfont			::							! Picture -> Font
setpictpendefaultfont	::							!*Picture -> *Picture
//	setpictpendefaultfont opens and sets the defaultFont (see StdFont).


/*	Drawing mode setting functions.
*/
setpictxormode			::							!*Picture -> *Picture
setpicthilitemode		::							!*Picture -> *Picture
setpictnormalmode		::							!*Picture -> *Picture


/*	Point drawing operations.
	pictdrawpoint
		only draws a point at that position. The pen position is not changed.
*/
pictdrawpoint			:: !Point					!*Picture -> *Picture


/*	Line drawing operations.
	pictdrawlineto
		draws a line from the current pen position to the given pen position. 
		The new pen position is the endpoint of the line.	
	pictdrawline
		draws a line from the first point to the second point. The pen position
		is not changed.
*/
pictdrawlineto			:: !Point					!*Picture -> *Picture
pictdrawline			:: !Point !Point			!*Picture -> *Picture


/*	Text drawing operations.
	pictdraw(char/string) draws a char/string at the current pen position. The new
		pen position is immediately after the drawn char/string.
*/
pictdrawchar			:: !Char					!*Picture -> *Picture
pictdrawstring			:: !String					!*Picture -> *Picture


/*	Oval drawing operations.
	pict(draw/fill)oval center oval 
		draws/fills an oval at center with horizontal and vertical radius. The new
		pen position is not changed.
*/
pictdrawoval			:: !Point !Oval				!*Picture -> *Picture
pictfilloval			:: !Point !Oval				!*Picture -> *Picture


/*	Curve drawing operations.
	pict(draw/fill)curve movePen point curve
		draws/fills a curve starting at point with a shape defined by curve. If movePen
		is True, then the new pen position is at the end of the curve, otherwise it does
		not change.
	getcurve_rect_begin_end point curve
		returns the enclosing rect of the curve and begin and end point lying on that
		curve.
*/
pictdrawcurve			:: !Bool !Point !Curve		!*Picture -> *Picture
pictfillcurve			:: !Bool !Point !Curve		!*Picture -> *Picture
getcurve_rect_begin_end	:: !Point !Curve					  -> (!(!Int,!Int,!Int,!Int),!Point,!Point)


/*	Rect drawing operations.
	pict(draw/fill)rect rect
		draws/fills a rect. The pen position is not changed.
*/
pictdrawrect			:: !(!Int,!Int,!Int,!Int)	!*Picture -> *Picture
pictfillrect			:: !(!Int,!Int,!Int,!Int)	!*Picture -> *Picture


/*	Polygon drawing operations.
	pict(draw/fill)polygon point polygon
		draws/fills a polygon starting at point. The pen position is not changed.
*/
pictdrawpolygon			:: !Point !Polygon			!*Picture -> *Picture
pictfillpolygon			:: !Point !Polygon			!*Picture -> *Picture


/*	Clipping operations.
	pictgetcliprgn returns the current clipping region.
	pictsetcliprgn sets the given clipping region.
*/
pictsetcliprgn			:: !OSRgnHandle				!*Picture -> (!OSRgnHandle,!*Picture)
